<?php
/*
Plugin Name: Add Some Bling
Plugin URI: http://www.planetstarta.com
Description: Add some bling.
Version: 1.0
Author: PlanetStarta
Author URI: http://www.planetstarta.com
Copyright: Copyright (c) 2012, PlanetStarta
License: Code in this file is licensed under GPLv2. Other files in this plugin licensed differently and separately. See the EULA you purchased under for details.
*/

add_filter('widget_text', 'do_shortcode');

define( BLINGPATH, plugin_dir_path( __FILE__ ) );
define( BLINGURL, plugin_dir_url(__FILE__) );

add_action('init', 'init_bling');
function init_bling() {		

	if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') ) {
		return;
	}
 
	if ( get_user_option('rich_editing') == 'true' ) {
		add_filter( 'mce_external_plugins', 'add_bling_plugin' );
		add_filter( 'mce_buttons', 'register_bling_button' );
	}
 
}

/* Add TinyMCE Plugin */
function add_bling_plugin( $plugin_array ) {
   $plugin_array['AddSomeBling'] = plugin_dir_url(__FILE__) . 'interface/AddSomeBling.js';
   return $plugin_array;
}

/* Register TinyMCE Button */
function register_bling_button( $buttons ) {
 array_push( $buttons, "|", "AddSomeBling", "|", "AddBlingHighlight" );
 return $buttons;
}

/* Setup bling shortcodes */

add_shortcode('addsomebling', 'showSomeBling');
function showSomeBling($atts, $content = null) {

	$atts = shortcode_atts( array( 
	      'type' => 'button',
	      'bling_pack' => 'basic_buttons',
	      'item' => 'red',
	      'text' => '',
	      'url' => '#',
	      'size' => 'large',
	      'icon' => '',
	      'align' => 'center'
	), $atts );

	if ( $atts['text'] == "" || $atts['text'] == " "){
		$text = "";
	} else {
		$text = '<span>' . $atts['text'] . '</span>';
	}
	 
	global $post;

	if ( $atts['type'] == 'button' ) {
		//buttons output
		if ( $atts['icon'] != "" ) {
			return '<div class="' . $atts['bling_pack'] . '_bling asb_' . $atts['align'] . '"><a class="' . $atts['item'] . ' asb_' . $atts['size'] . '" href="' . $atts['url'] . '"><i class="icon-' . $atts['icon'] . '"></i>' . $text . '</a></div>';
		} else {
			return '<div class="' . $atts['bling_pack'] . '_bling asb_' . $atts['align'] . '"><a class="' . $atts['item'] . ' asb_' . $atts['size'] . '" href="' . $atts['url'] . '">' . $text . '</a></div>';
		}
	
	} else if ( $atts['type'] == 'divider' ) {
		//divider output
		if ( $atts['size'] != '' ) { $atts['size'] = ' style="width:' . $atts['size'] . '%;"'; }
		return '<div style="z-index:5;position:relative;"><div class="' . $atts['bling_pack'] . '_bling"' . $atts['size'] . '><div class="' . $atts['item'] . '"><div></div></div></div></div>';
	}

}

add_shortcode('addsomebling_box', 'showSomeBling_box');
function showSomeBling_box($atts, $content = null) {

	$atts = shortcode_atts( array( 
	      'bling_pack' => 'shadow_boxes',
	      'item' => 'lifted',
	      'size' => '',
	      'icon' => '',
	), $atts );
	 
	global $post;

	if ( $atts['size'] != '' ) { $atts['size'] = ' style="width:' . $atts['size'] . '%;"'; }

	if ( $atts['icon'] != "" ) {
		return '<div style="z-index:5;position:relative;"><div class="' . $atts['bling_pack'] . '_bling ' . $atts['item'] . '"' . $atts['size'] . '><i class="icon-' . $atts['icon'] . '"></i><div class="asb_boxcontent">' . do_shortcode($content) . '</div></div></div>';
	} else {
		return '<div style="z-index:5;position:relative;"><div class="' . $atts['bling_pack'] . '_bling ' . $atts['item'] . '"' . $atts['size'] . '>' . do_shortcode($content) . '</div></div>';
	}

	return '<div style="z-index:5;position:relative;"><div class="' . $atts['bling_pack'] . '_bling ' . $atts['item'] . '"' . $atts['size'] . '>' . do_shortcode($content) . '</div></div>';

}

add_shortcode('addsomebling_closeit', 'showSomeBling_closeit');
function showSomeBling_closeit($atts, $content = null) {

	$atts = shortcode_atts( array( 
	      'type' => 'headline',
	      'bling_pack' => 'bling_headlines',
	      'item' => 'bh_lead_default',
	      'size' => '',
	), $atts );
	 
	global $post;

	if ( $atts['type'] == 'headline' ) {
		//boxes output
		if ( $atts['size'] != '' ) { $atts['size'] = ' style="width:' . $atts['size'] . '%;"'; }
		return '<span class="' . $atts['bling_pack'] . '_bling ' . $atts['item'] . '"' . $atts['size'] . '>' . do_shortcode($content) . '</span>';

	} else if ( $atts['type'] == 'list' ) {
		//boxes output
		if ( $atts['size'] != '' ) { $atts['size'] = ' asb_' . $atts['size']; } else { $atts['size'] = ' asb_small'; }
		return '<div class="' . $atts['bling_pack'] . '_bling ' . $atts['item'] . $atts['size'] . '">' . do_shortcode($content) . '</div>';
		
	}

}

add_shortcode('asb_highlight', 'showSomeBling_highlight');
function showSomeBling_highlight($atts, $content = null) {

	$atts = shortcode_atts( array( 

	), $atts );
	 
	global $post;

	return '<span class="asb_highlight">' . do_shortcode($content) . '</span>';

}

add_action('admin_menu', 'bling_admin_menu');
function bling_admin_menu() {
	$admin_pages = array();

	$page_title = __('AddSomeBling : Settings', 'asb');
	$menu_title = __('Add Some Bling', 'asb');
	$capability = 'manage_options';
	$menu_slug = 'asb-settings';
	$function = 'asb_settings';
	$icon_url = BLINGURL . '/interface/asb16.png';
	add_menu_page($page_title, $menu_title, $capability, $menu_slug, $function, $icon_url);
	
	// We add this submenu page with the same slug as the parent to ensure we don't get duplicates
	$sub_menu_title = __('Add Some Bling', 'asb');
	$admin_pages[] = add_submenu_page($menu_slug, $page_title, $sub_menu_title, $capability, $menu_slug, $function);
	
}

register_deactivation_hook( __FILE__, 'asb_deactivate' );
function asb_deactivate() {
	delete_option( 'asb_options' );
}

function asb_settings() { ?>
	
	<div class="wrap asbsettings">
	<div id="icon-options-general" class="icon32"><br /></div>
	<h2>ADD SOME BLING Settings</h2>

	<form class="tssavebutton" action="options.php" method="post">
	<?php settings_fields('asb_options'); ?>
	<?php do_settings_sections('asboptions'); ?>
	</form>

	</div>

	<?php
}

add_action('admin_init', 'asb_admin_init');
function asb_admin_init(){

	register_setting( 'asb_options', 'asb_options', 'asb_options_validate' );

	add_settings_section('asb_basics', '', 'asb_basics_section_text', 'asboptions');
	add_settings_field('asb_select_blingpacks', '', 'asb_select_blingpacks', 'asboptions', 'asb_basics');
}

function asb_basics_section_text() {
echo '<p>Choose the Bling Packs you want to use</p>';
}

function asb_select_blingpacks() {

	/* Scan for bling packs */
	$path = BLINGPATH . '/bling-packs/';
	$results = scandir($path);

	$bling_packs = array();

	foreach ($results as $result) {
		if ($result === '.' or $result === '..') continue;

		if (is_dir($path . '/' . $result)) {
			array_push( $bling_packs, $result );
		}

	}

	$options = (array) get_option('asb_options');

	if (!isset($options['asb_select_blingpacks'])) {
		$options['asb_select_blingpacks'] = $bling_packs;
	}

	?>

	<link rel="stylesheet" type="text/css" media="screen" href="<?php echo BLINGURL . 'interface/bling_interface.css'; ?>" />
	<link rel="stylesheet" type="text/css" media="screen" href="<?php echo BLINGURL . 'bling-packs/asbicons.css'; ?>" />

	<?php foreach ($bling_packs as $bling_pack) { ?>
	<link rel="stylesheet" type="text/css" media="screen" href="<?php echo BLINGURL . 'bling-packs/' . $bling_pack . '/styles.css'; ?>" />
	<?php } ?>
	<link rel="stylesheet" type="text/css" media="screen" href="<?php echo BLINGURL . 'asb_default.css'; ?>" />
	<?php
	echo "<div class='bling_checklist'>";
	echo "<div><input class='settingssavebtn' name='Save Changes' type='submit' value='Save Changes' /></div>";

	$html = "";
	$count = 0;
	foreach ($bling_packs as $bling_pack) {
		include $path . '/' . $bling_pack . '/config.php';

		$checked = checked( $options['asb_select_blingpacks'][$count], $bling_pack, false );
		$html .= '<p>';  
		$html .= '<input type="checkbox" id="'.$bling_pack.'_check" value="'.$bling_pack.'" name="asb_options[asb_select_blingpacks]['.$count.']"' . $checked . ' />';  
		$html .= '<label for="'.$bling_pack.'_check"> '.$config['name'].'</label><br />';
   		$html .= '</p>';  
		
   		$count++;
	}
	echo $html;
	echo "</div>";

	$adding_bling = false;

	include BLINGPATH . 'interface/bling_pack_selectors.php';

}

// validate settings
function asb_options_validate($input) {
	return $input;
}



/* Load up bling styles */
add_action( 'wp_enqueue_scripts', 'load_bling_styles', 999 );
function load_bling_styles() {

	$icons = false;

	$path = BLINGPATH . '/bling-packs/';

	$options = (array) get_option('asb_options');

	if (!isset($options['asb_select_blingpacks'])) {
		// Scan for bling packs

		$results = scandir($path);

		$bling_packs = array();

		foreach ($results as $result) {
			if ($result === '.' or $result === '..') continue;

			if (is_dir($path . '/' . $result)) {
				array_push( $bling_packs, $result );
			}

		}

	} else {

		$bling_packs = (array) $options['asb_select_blingpacks'];

	}

    
	foreach ($bling_packs as $bling_pack) {

		include $path . '/' . $bling_pack . '/config.php';

		if ( isset($config['icons']) && $config['icons'] == "true" ){
			$icons = true;
		}

		wp_register_style( 'asb' . $bling_pack , BLINGURL . 'bling-packs/' . $bling_pack . '/styles.css' );
		wp_enqueue_style( 'asb' . $bling_pack );

	}

	if ( $icons ) {
		wp_register_style( 'asbicons', BLINGURL . 'bling-packs/asbicons.css' );
		wp_enqueue_style( 'asbicons' );
	}

	wp_register_style( 'asbdefault', BLINGURL . 'asb_default.css' );
	wp_enqueue_style( 'asbdefault' );
	
}

?>