// JavaScript Document
(function() {
    tinymce.create('tinymce.plugins.AddSomeBling', {
        init : function(editor, url) {

            editor.addCommand("mceAddSomeBling", function() {
                editor.windowManager.open(
                    {
                        title: "Add Some Bling",
                        file: url + "/bling_interface.php",
                        width: 960,
                        height: 800,
                        inline: 1
                    },
                    { plugin_url: url }
                )}
            );
            
            editor.addButton("AddSomeBling", {
                title: "Add Some Bling",
                cmd: "mceAddSomeBling",
                image: url + "/asb.png"
            });
            
            editor.addButton("AddBlingHighlight", {
                title: "Add Bling Highlight Shortcode",
                cmd: "mceAddHighlightBling",
                image: url + "/asbhighlight.png",
                onclick : function() {
                    editor.selection.setContent('[asb_highlight]' + editor.selection.getContent() + '[/asb_highlight]');
                }
            });

        },
        createControl : function(n, cm) {
            return null;
        },
    });
    tinymce.PluginManager.add('AddSomeBling', tinymce.plugins.AddSomeBling);
})();