<?php require('../../../../wp-load.php');
 
	$path = BLINGPATH . '/bling-packs/';

	$options = (array) get_option('asb_options');

    if (!isset($options['asb_select_blingpacks'])) {
		// Scan for bling packs

		$results = scandir($path);

		$bling_packs = array();

		foreach ($results as $result) {
			if ($result === '.' or $result === '..') continue;

			if (is_dir($path . '/' . $result)) {
				array_push( $bling_packs, $result );
			}

		}

	} else {

		$bling_packs = (array) $options['asb_select_blingpacks'];

	}

?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" style="background:#fff;">
<head>
<title><?php _e('Add Some Bling', 'addsomebling') ?></title>
<link rel="stylesheet" type="text/css" media="screen" href="<?php echo BLINGURL . 'interface/bling_interface.css'; ?>" />
<link rel="stylesheet" type="text/css" media="screen" href="<?php echo BLINGURL . 'bling-packs/asbicons.css'; ?>" />
<?php foreach ($bling_packs as $bling_pack) { ?>
<link rel="stylesheet" type="text/css" media="screen" href="<?php echo BLINGURL . 'bling-packs/' . $bling_pack . '/styles.css'; ?>" />
<?php } ?>
<link rel="stylesheet" type="text/css" media="screen" href="<?php echo BLINGURL . 'asb_default.css'; ?>" />
<script type="text/javascript" src="<?php echo includes_url() ?>js/jquery/jquery.js"></script>
<script type="text/javascript" src="<?php echo includes_url() ?>js/tinymce/tiny_mce_popup.js"></script>

<script type="text/javascript">
function addButtonBling(type, bling_pack, item, text, url, size, align, icon) {
	var shortcode = '';

	if (! text) {
		text = '';
	} else {
		text = ' text="' + text + '"';
	}

	if (! url) {
		url = ' url="#"';
	} else {
		url = ' url="' + url + '"';
	}

	if (! size) {
		size = ' size="large"';
	} else {
		size = ' size="' + size + '"';
	}

	//if (! align) {
	//	align = '';
	//} else {
		align = ' align="' + align + '"';
	//}

	if (! icon) {
		icon = '';
	} else {
		icon = ' icon="' + icon + '"';
	}

	shortcode = '[addsomebling type="' + type + '" bling_pack="' + bling_pack + '" item="' + item + '"' + text + url + size + align + icon + ']';
	
	if (window.tinyMCE) {
		window.tinyMCE.execInstanceCommand("content", "mceInsertContent", false, shortcode);
		tinyMCEPopup.editor.execCommand("mceRepaint");
		tinyMCEPopup.close();
	}
}

function addBoxBling(type, bling_pack, item, size, icon) {
	var shortcode = '';

	if (! size) {
		size = '';
	} else {
		size = ' size="' + size + '"';
	}

	if (! icon) {
		icon = '';
	} else {
		icon = ' icon="' + icon + '"';
	}

	shortcode = '[addsomebling_box bling_pack="' + bling_pack + '" item="' + item + '"' + size + icon + ']Type your box content here in between the tags.[/addsomebling_box]';
	
	if (window.tinyMCE) {
		window.tinyMCE.execInstanceCommand("content", "mceInsertContent", false, shortcode);
		tinyMCEPopup.editor.execCommand("mceRepaint");
		tinyMCEPopup.close();
	}
}

function addDividerBling(type, bling_pack, item, size) {
	var shortcode = '';
	if (size != '') {
		shortcode = '[addsomebling type="' + type + '" bling_pack="' + bling_pack + '" item="' + item + '" size="' + size + '"]';
	} else {
		shortcode = '[addsomebling type="' + type + '" bling_pack="' + bling_pack + '" item="' + item + '"]';
	}
	
	if (window.tinyMCE) {
		window.tinyMCE.execInstanceCommand("content", "mceInsertContent", false, shortcode);
		tinyMCEPopup.editor.execCommand("mceRepaint");
		tinyMCEPopup.close();
	}
}

function addListBling(type, bling_pack, item, size) {
	var shortcode = '';

	if (! size) {
		size = ' size="small"';
	} else {
		size = ' size="' + size + '"';
	}

	shortcode = '[addsomebling_closeit type="' + type + '" bling_pack="' + bling_pack + '" item="' + item + '"' + size + ']<ul><li>Example List Item</li></ul>[/addsomebling_closeit]';
	
	if (window.tinyMCE) {
		window.tinyMCE.execInstanceCommand("content", "mceInsertContent", false, shortcode);
		tinyMCEPopup.editor.execCommand("mceRepaint");
		tinyMCEPopup.close();
	}
}

function addHeadlineBling(type, bling_pack, item) {
	var shortcode = '';

	shortcode = '[addsomebling_closeit type="' + type + '" bling_pack="' + bling_pack + '" item="' + item + '"]Write your headline here in between the tags.[/addsomebling_closeit]';
	
	if (window.tinyMCE) {
		window.tinyMCE.execInstanceCommand("content", "mceInsertContent", false, shortcode);
		tinyMCEPopup.editor.execCommand("mceRepaint");
		tinyMCEPopup.close();
	}
}
</script>

</head>

<body style="background:#fff;">

<div class="asbsettings">
<?php $adding_bling = true; include BLINGPATH . 'interface/bling_pack_selectors.php'; ?>
</div>

</body>
</html>